---
name: utm-link-helper
description: Generate canonical UTM-tagged waitlist links and optional shortlink mappings for outreach experiments. Use when agents need consistent tracking links for contact forms and outreach landing pages.
---

# UTM Link Helper

Generates canonical UTM-tagged URLs using the project's base waitlist URL and a campaign id. Optionally prepares a shortlink mapping file (requires a shortlink service/credentials).

Inputs:
- base_url (default: https://afunls.github.io/replypilot-waitlist/)
- campaign_id (e.g., exp01_contactform_50_2026_02_24)
- content_tag (e.g., hvac_v1)
- shortlink_service (optional)

Outputs:
- canonical_link.txt
- shortlink_map.json (if shortlink created)

Success criteria:
- canonical_link.txt is a valid, reachable URL (http status 200 on web_fetch)
- shortlink_map.json maps short -> canonical

Where to write outputs:
- projects/agent-marketplace/outputs/utm-link-helper/<timestamp>/

Notes:
- If shortlink service creds are missing, produce only the canonical link and instructions to create shortlinks manually.
- Always include utm_source=contactform and utm_medium=outbound by default.
