---
name: contactform-submitter
description: Assist agents in filling and submitting contact forms reliably across common small-business sites (HVAC, plumbing, roofing), with UTM-tagged links and logging. Use when automating or preparing contact-form submissions for outreach experiments.
---

# Contact Form Submitter

This skill packages per-target contact-form submissions: the form payload, the canonical UTM link to use, and a JSONL log row template to append to state/contactform-log.jsonl.

Inputs:
- target_url
- company_name
- vertical (hvac|plumbing|other)
- variant (v1|v2)
- utm_link (canonical or shortlink)

Outputs:
- submission.json (payload to paste into the form)
- log-row.jsonl (single-line JSON ready to append to state/contactform-log.jsonl)

Success criteria:
- submission.json contains all required fields detected or the best-effort mapping
- log-row.jsonl includes timestamp, target_url, company_name, vertical, variant, utm_link, agent

Where to write outputs:
- projects/agent-marketplace/outputs/contactform-submitter/<timestamp>/

When to use:
- Contact-form outbound experiments (ReplyPilot)
- Manual fallback when Gmail outbound is paused

Security & provenance:
- All target data must be discovered via web_search or web_fetch (no LLM hallucinated companies).
- Record source URL in the log row.
